/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.URISplit;

public class ReplaceFilePanel
extends JPanel {
    private DataSetSelector dataSetSelector1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public ReplaceFilePanel() {
        this.initComponents();
        this.dataSetSelector1.setHidePlayButton(true);
        this.dataSetSelector1.setSuggestFiles(true);
        this.dataSetSelector1.setSuggestFsAgg(true);
    }

    public void setApplicationModel(ApplicationModel appModel) {
        String ext = this.dataSetSelector1.getBrowseTypeExt();
        List<String> urls = AutoplotUtil.getUrls(appModel.getRecent());
        ArrayList<String> urls1 = new ArrayList<String>();
        for (String url : urls) {
            URISplit split = URISplit.parse((String)url);
            if (!ext.equals(split.ext)) continue;
            urls1.add(split.file);
        }
        this.dataSetSelector1.setDisableDataSources(true);
        this.dataSetSelector1.setRecent(urls1);
        this.dataSetSelector1.setBrowseTypeExt(ext);
        this.dataSetSelector1.getValue();
    }

    public void setCurrentFile(String file) {
        this.jLabel2.setText(file);
        URISplit split = URISplit.parse((String)file);
        this.dataSetSelector1.setValue(file);
        this.dataSetSelector1.setBrowseTypeExt(split.ext);
    }

    public String getSelectedFile() {
        return this.dataSetSelector1.getValue();
    }

    public static void main(String[] args) {
        ReplaceFilePanel rfp = new ReplaceFilePanel();
        rfp.setCurrentFile("https://cdaweb.gsfc.nasa.gov/sp_phys/data/mms/mms1/edp/slow/l2/scpot/2016/01/mms1_edp_slow_l2_scpot_20160104000000_v2.7.0.cdf?mms1_edp_psp_slow_l2");
        JOptionPane.showMessageDialog(null, rfp);
        System.err.println(rfp.getSelectedFile());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.dataSetSelector1 = new DataSetSelector();
        this.jLabel1.setText("Replace references to the file:");
        this.jLabel2.setText("jLabel2");
        this.jLabel3.setText("With the new file name:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 470, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent((Component)this.dataSetSelector1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jLabel3, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dataSetSelector1, -2, -1, -2).addGap(0, 169, Short.MAX_VALUE)));
    }
}

